/**
 * XXXX
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (03/06/08)
 */   
package com.ejie.p06b.pdf;

import java.text.SimpleDateFormat;
import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;

import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.manager.P06BCorredoresManager;
import com.ejie.p06b.pdf.xml.P06BCartasDECXML;
import com.ejie.p06b.util.P06BParametros;
import com.ejie.p06b.xlnet.P06BPerfilUsuario;



/**
 * Clase que gestiona la generacin del pdf
 */
public class P06BCartasDECPDF implements P06BIPDF{
    private static long numeroPDF = 0;
	
	public String getXmlPdf(HttpServletRequest request){
    	String xmlPdf = null;
    	try {
    		java.util.Date fechaHoy = new java.util.Date();
    		String ejercicio = "";
    		try{
    			SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
    	   		ejercicio = simpleDateFormat.format(fechaHoy);
    		}catch(Exception e){
    			P06BLog.send(2,this.getClass().getName(),"Error obteniendo el ejercicio actual: " + e.toString());
    		}
    		
    		//Obtener la where con los criterios de busqueda
	    	//String where = (String)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"Corredor"+P06BConstantes.P06B_VAR_TEMP_FILTRO);
			//De momento NO hay pantalla de filtrado para mostrar este PDF, as que ponemos la where directamente.
    		    		
    		//Sacar la carta de los mediadores que estn en activo en la base de datos a 31 de diciembre del ejercicio anterior.
    		//Sacar los que se encuentren de baja o suspensin actualmente pero que a 31 de diciembre del ejercico anterior se encontrasen activos - SI
    		StringBuffer where = new StringBuffer("");

    		//Si se trata de una DEC anterior al 2010, no obligar a los vinculados
    		//Si se trata de la DEC 2010 o posteriores, s obligar a los vinculados
    		//Como el usuario no introduce el ejercicio, sino que se sacan los mediadores de la DEC que corresponde, y estamos a 09/09/2011,
    		//quitamos directamente el filtro de los vinculados porque a partir de esta fecha ya es obligatorio. Si en un futuro se le
    		//solicitara al usuario el ejercicio por pantalla, habra que considerar los vinculados.
    		//where.append(" where " + P06BTablas.P06B_P06B20_CLASE + " <> '" + P06BConstantes.P06B_AGENTEVINCULADO_FISICA + "'");
    		//where.append(" and " + P06BTablas.P06B_P06B20_CLASE + " <> '" + P06BConstantes.P06B_AGENTEVINCULADO_JURIDICA + "'");
    		where.append(" where " + P06BTablas.P06B_P06B20_FECHAAL + " <= TO_DATE('31/12/"+(Integer.parseInt(ejercicio) - 1)+"', 'dd/mm/yyyy')");
    		where.append(" and (");
	    		where.append(" (" + P06BTablas.P06B_P06B20_ESTADO + " = '" +  P06BConstantes.P06B_CORREDORES_ESTADO_ALTA + "')");
	    		where.append(" or (" + P06BTablas.P06B_P06B20_ESTADO + " = '" +  P06BConstantes.P06B_CORREDORES_ESTADO_PDTE_BAJA + "')");
	    		where.append(" or (" + P06BTablas.P06B_P06B20_ESTADO + " = '" +  P06BConstantes.P06B_CORREDORES_ESTADO_REVISION + "')");
	    		where.append(" or (" + P06BTablas.P06B_P06B20_ESTADO + " = '" +  P06BConstantes.P06B_CORREDORES_ESTADO_BAJA + "' and " + 
	    				P06BTablas.P06B_P06B20_FECHABAJ + " >= TO_DATE('01/01/"+ejercicio+"', 'dd/mm/yyyy'))");
	    		where.append(" or (" + P06BTablas.P06B_P06B20_ESTADO + " = '" +  P06BConstantes.P06B_CORREDORES_ESTADO_SUSPENSION + "' and " + 
	    				P06BTablas.P06B_P06B20_FECHASUS + " >= TO_DATE('01/01/"+ejercicio+"', 'dd/mm/yyyy'))");
    		where.append(" )");
    		    		    	
    		P06BLog.send(2,this.getClass().getName()+ " - getXmlPdf", "WHERE para el listado PDF: " + where.toString());
			
			//Obtener el listado de corredores que cumplen los criterios de bsqueda
    		//Nos vale el mismo mtodo que se utiliza para imprimir el PDF del listado de la bsqueda
			ArrayList corredoresCartasDEC = P06BCorredoresManager.getInstance().selectCorredoresListadoBusqueda(where.toString());
					
			//Obtenemos el XML a partir de los datos
			P06BLog.send(2,this.getClass().getName()+ " - getXmlPdf", "Antes de obtener el XML de datos");
			xmlPdf = P06BCartasDECXML.getXml(corredoresCartasDEC, request);
			P06BLog.send(2,this.getClass().getName()+ " - getXmlPdf", "Despues de obtener el XML de datos");
    	}catch( Exception e) {
			P06BLog.send(2,this.getClass().getName()+ " - getXmlPdf", "Error al obtener el XML: " + e.getMessage());
			return null;
		}
    	
		return xmlPdf;
    }
    
    public String getXsltFichero(HttpServletRequest request){
    	String xsltFichero = null;
    	try {
			//Obtener el idioma
			String idioma = null;
			P06BPerfilUsuario perfilUsuario = (P06BPerfilUsuario) request.getSession().getAttribute(P06BConstantes.P06B_VAR_PERFIL_USUARIO);
			if (perfilUsuario != null){
				P06BLog.send(2,this.getClass().getName() + " - getXsltFichero", "Existe objeto perfilUsuario");
				idioma = perfilUsuario.getIdIdioma();
			}else{
				P06BLog.send(2,this.getClass().getName() + " - getXsltFichero", "NOOOOOO Existe objeto perfilUsuario");
			}
			if (idioma == null || idioma.equals("") ){
				idioma = P06BConstantes.P06B_IDIOMA_ES; //"es"
			}
			P06BLog.send(2,this.getClass().getName() + " - getXsltFichero", "Idioma: "+idioma);
			
			//De momento solo est en castellano
			//xsltFichero = P06BParametros.getListado("pdf.xsl.listadoBusqueda_"+idioma);
			xsltFichero = P06BParametros.getListado("pdf.xsl.cartasDEC");
			
    	}catch( Exception e) {
			P06BLog.send(2,this.getClass().getName() + " - getXsltFichero", "Error al obtener el nombre del xslt: " + e.getMessage());
			return null;
		}
    	return xsltFichero;
    }
	
}